export enum ApiConfig {
  apiVersion = '/1.4',
  userLogin = '/auth/login',
  userLogout = '/auth/logout',
  userRegistration = '/auth/registration',
  userResendEmail = '/auth/registration/resend-email',
  userVerifyEmail = '/auth/registration/verify-email',
  userResetPass = '/auth/password/reset',
  userChangePass = '/auth/password/change',
  userProfile = '/auth/user',
  userDashboard = '/auth/user/dashboard',
  userFormats = '/auth/user_schedule_items/formats',
  userScheduleNotifications = '/auth/schedule_notifications',
  userScheduleNotification = `/auth/schedule_notifications/:id`,
  userSchedulePeriods = '/auth/periods',
  userScheduleInstitutions = '/auth/user_schedule_items/institutions',
  userScheduleInstitution = '/auth/user_schedule_items/institutions/:id',
  userScheduleItemComments = '/auth/user_schedule_items/:id/comments',
  userScheduleItemCommentUpdate = '/auth/user_schedule_items/comments/:id/edit',
  showcases = '/showcases',
  showcasesDatasets = '/showcases/:id/datasets',
  suggestShowcases = '/showcases/suggest',
  articles = '/articles',
  institutions = '/institutions',
  datasets = '/datasets',
  datasetsShowcases = '/datasets/:id/showcases',
  datasetFeedback = '/datasets/:id/comments',
  datasetsFilesDownload = '/datasets/:resourceId/resources/files/download',
  stats = '/stats',
  history = '/histories',
  search = '/search',
  searchHistory = '/searchhistories',
  resources = '/datasets/:id/resources',
  resourceDetails = '/resources/:resourceId',
  resourceGeoData = '/resources/:resourceId/geo',
  resourceChart = '/resources/:resourceId/chart',
  resourceChartDelete = '/resources/charts/:chartId',
  resourceChartsUpdate = '/resources/:resourceId/charts/:chartId',
  resourceCharts = '/resources/:resourceId/charts',
  resourceData = '/resources/:resourceId/data',
  resourceFeedback = '/resources/:resourceId/comments',
  submissions = '/submissions',
  acceptedSubmissions = '/submissions/accepted',
  acceptedSubmission = '/submissions/accepted/:id',
  acceptedPublicSubmissions = '/submissions/accepted/public',
  acceptedPublicSubmissionComment = '/submissions/accepted/public/:id/comment',
  subscribe = '/auth/subscriptions',
  unsubscribe = '/auth/subscriptions/:subscriptionId',
  activityNotifications = '/auth/notifications',
  markAllNotificationsAsRead = '/auth/notifications/status',
  subscribeNewsletter = '/auth/newsletter/subscribe',
  unsubscribeNewsletter = '/auth/newsletter/unsubscribe',
  confirmSubscribeNewsletter = '/auth/newsletter/subscribe/:token/confirm',
  searchSuggest = '/search/suggest',
  aodCourses = '/courses',
  lab = '/laboratory',
  dataProposal = '/submissions/accepted',
  dataProposalFeedback = '/feedback',
  meetings = '/meetings',
  schedules = '/auth/schedules',
  userSchedules = '/auth/user_schedules',
  userScheduleItems = '/auth/user_schedule_items',
  scheduleAgents = '/auth/schedule_agents',
  mock = '/mock',
  guides = '/guides',
  catalog = '/catalog',
  sparql = '/sparql',
  rdfDoc = '/doc?urls.primaryName=DANE.GOV.PL%20RDF%20API',
  licenses = '/licenses/',
  dga_aggregated = '/dga-aggregated',
  logingovpl = '/logingovpl',
  brokenlinks = '/reports/brokenlinks',
  brokenlinksdata = '/reports/brokenlinks/data'
}
