
// Object.defineProperty(document, 'doctype', {
//   value: '<!DOCTYPE html>'
// });

// globalSetupTest.js
module.exports = async function() {
  const mock = () => {
    let storage = {};
    return {
      getItem: key => key in storage ? storage[key] : null,
      setItem: (key, value) => storage[key] = value || '',
      removeItem: key => delete storage[key],
      clear: () => storage = {},
    };
  };

  Object.defineProperty(window, 'localStorage', {value: mock()});
  Object.defineProperty(window, 'sessionStorage', {value: mock()});
  console.log(`global setup: ${global}`);
};


// Object.defineProperty(window, 'getComputedStyle', {
//   value: () => {
//     return {
//       display: 'none',
//       appearance: ['-webkit-appearance']
//     };
//   }
// });
// /**
//  * ISSUE: https://github.com/angular/material2/issues/7101
//  * Workaround for JSDOM missing transform property
//  */
// Object.defineProperty(document.body.style, 'transform', {
//   value: () => {
//     return {
//       enumerable: true,
//       configurable: true,
//     };
//   },
// });
